/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import net.minecraft.class_7923;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.item.ITinkerStationDisplay;
import slimeknights.tconstruct.library.tools.layout.LayoutIcon;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.TinkerTooltipFlags;
import slimeknights.tconstruct.tables.block.entity.table.TinkerStationBlockEntity;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.client.inventory.module.InfoPanelScreen;
import slimeknights.tconstruct.tables.client.inventory.widget.SlotButtonItem;
import slimeknights.tconstruct.tables.client.inventory.widget.TinkerStationButtonsWidget;
import slimeknights.tconstruct.tables.menu.TinkerStationContainerMenu;
import slimeknights.tconstruct.tables.menu.slot.TinkerStationSlot;
import slimeknights.tconstruct.tables.network.TinkerStationRenamePacket;
import slimeknights.tconstruct.tables.network.TinkerStationSelectionPacket;

public class TinkerStationScreen
extends BaseTabbedScreen<TinkerStationBlockEntity, TinkerStationContainerMenu> {
    private static final class_2561 COMPONENTS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.components");
    private static final class_2561 MODIFIERS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.modifiers");
    private static final class_2561 UPGRADES_TEXT = TConstruct.makeTranslation("gui", "tinker_station.upgrades");
    private static final class_2561 TRAITS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.traits");
    private static final class_2561 ASCII_ANVIL = class_2561.method_43470((String)"\n\n").method_27693("       .\n").method_27693("     /( _________\n").method_27693("     |  >:=========`\n").method_27693("     )(  \n").method_27693("     \"\"").method_27692(class_124.field_1063);
    private static final int STILL_FILLED_X = 112;
    private static final int STILL_FILLED_Y = 62;
    private static final int STILL_FILLED_SPACING = 18;
    private static final class_2960 TINKER_STATION_TEXTURE = TConstruct.getResource("textures/gui/tinker_station.png");
    private static final ElementScreen ACTIVE_TEXT_FIELD = new ElementScreen(0, 210, 91, 12, 256, 256);
    private static final ElementScreen ITEM_COVER = new ElementScreen(176, 18, 70, 64);
    private static final ElementScreen SLOT_BACKGROUND = new ElementScreen(176, 0, 18, 18);
    private static final ElementScreen SLOT_BORDER = new ElementScreen(194, 0, 18, 18);
    private static final ElementScreen SLOT_SPACE_TOP = new ElementScreen(0, 176, 18, 2);
    private static final ElementScreen SLOT_SPACE_BOTTOM = new ElementScreen(0, 174, 18, 2);
    private static final ElementScreen PANEL_SPACE_LEFT = new ElementScreen(0, 174, 5, 4);
    private static final ElementScreen PANEL_SPACE_RIGHT = new ElementScreen(9, 174, 9, 4);
    private static final ElementScreen LEFT_BEAM = new ElementScreen(0, 180, 2, 7);
    private static final ElementScreen RIGHT_BEAM = new ElementScreen(131, 180, 2, 7);
    private static final ScalableElementScreen CENTER_BEAM = new ScalableElementScreen(2, 180, 129, 7);
    private static final ElementScreen TEXT_BOX = new ElementScreen(0, 222, 90, 12);
    public static final int COLUMN_COUNT = 5;
    protected ElementScreen buttonDecorationTop = SLOT_SPACE_TOP;
    protected ElementScreen buttonDecorationBot = SLOT_SPACE_BOTTOM;
    protected ElementScreen panelDecorationL = PANEL_SPACE_LEFT;
    protected ElementScreen panelDecorationR = PANEL_SPACE_RIGHT;
    protected ElementScreen leftBeam = new ElementScreen(0, 0, 0, 0);
    protected ElementScreen rightBeam = new ElementScreen(0, 0, 0, 0);
    protected ScalableElementScreen centerBeam = new ScalableElementScreen(0, 0, 0, 0);
    @Nonnull
    private final StationSlotLayout defaultLayout;
    @Nonnull
    private StationSlotLayout currentLayout;
    protected class_342 textField;
    protected InfoPanelScreen tinkerInfo;
    protected InfoPanelScreen modifierInfo;
    protected TinkerStationButtonsWidget buttonsScreen;
    private final int maxInputs;
    protected int activeInputs;

    public TinkerStationScreen(TinkerStationContainerMenu container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        this.tinkerInfo = new InfoPanelScreen(this, container, playerInventory, title);
        this.tinkerInfo.setTextScale(0.8888889f);
        this.addModule(this.tinkerInfo);
        this.modifierInfo = new InfoPanelScreen(this, container, playerInventory, title);
        this.modifierInfo.setTextScale(0.7777778f);
        this.addModule(this.modifierInfo);
        this.tinkerInfo.yOffset = 5;
        this.modifierInfo.yOffset = this.tinkerInfo.field_2779 + 9;
        this.field_2779 = 174;
        int max = 5;
        TinkerStationBlockEntity te = (TinkerStationBlockEntity)container.getTile();
        if (te != null) {
            max = te.getInputCount();
        }
        this.maxInputs = max;
        if (max > 3) {
            this.metal();
        } else {
            this.wood();
        }
        this.defaultLayout = te == null ? StationSlotLayout.EMPTY : StationSlotLayoutLoader.getInstance().get(class_7923.field_41175.method_10221((Object)te.method_11010().method_26204()));
        this.currentLayout = this.defaultLayout;
        this.activeInputs = Math.min(this.defaultLayout.getInputCount(), max);
    }

    @Override
    public void method_25426() {
        assert (this.field_22787 != null);
        this.field_2800 += 4;
        this.cornerY += 4;
        this.tinkerInfo.xOffset = 2;
        this.tinkerInfo.yOffset = this.centerBeam.h + this.panelDecorationL.h;
        this.modifierInfo.xOffset = this.tinkerInfo.xOffset;
        this.modifierInfo.yOffset = this.tinkerInfo.yOffset + this.tinkerInfo.field_2779 + 4;
        for (ModuleScreen module : this.modules) {
            module.field_2800 += 4;
        }
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.textField = new class_342(this.field_22793, x + 80, y + 5, 82, 9, (class_2561)class_2561.method_43473());
        this.textField.method_1856(true);
        this.textField.method_1868(-1);
        this.textField.method_1860(-1);
        this.textField.method_1858(false);
        this.textField.method_1880(50);
        this.textField.method_1863(this::onNameChanged);
        this.textField.method_1852("");
        this.method_25429((class_364)this.textField);
        this.textField.field_22764 = false;
        this.textField.method_1888(false);
        super.method_25426();
        int buttonsStyle = this.maxInputs > 3 ? 1 : 2;
        ArrayList layouts = Lists.newArrayList();
        layouts.add(this.defaultLayout);
        layouts.addAll(StationSlotLayoutLoader.getInstance().getSortedSlots().stream().filter(layout -> layout.getInputSlots().size() <= this.maxInputs).toList());
        this.buttonsScreen = new TinkerStationButtonsWidget(this, this.cornerX - TinkerStationButtonsWidget.width(5) - 2, this.cornerY + this.centerBeam.h + this.buttonDecorationTop.h, layouts, buttonsStyle);
        this.updateLayout();
    }

    public void updateLayout() {
        int stillFilled = 0;
        for (int i = 0; i <= this.maxInputs; ++i) {
            TinkerStationSlot tinkerSlot;
            class_1735 slot = ((TinkerStationContainerMenu)((Object)this.getMenu())).method_7611(i);
            LayoutSlot layoutSlot = this.currentLayout.getSlot(i);
            if (layoutSlot.isHidden()) {
                slot.field_7873 = 112 - 18 * stillFilled;
                slot.field_7872 = 62;
                ++stillFilled;
                if (!(slot instanceof TinkerStationSlot)) continue;
                tinkerSlot = (TinkerStationSlot)slot;
                tinkerSlot.deactivate();
                continue;
            }
            slot.field_7873 = layoutSlot.getX();
            slot.field_7872 = layoutSlot.getY();
            if (!(slot instanceof TinkerStationSlot)) continue;
            tinkerSlot = (TinkerStationSlot)slot;
            tinkerSlot.activate(layoutSlot);
        }
        this.updateDisplay();
    }

    static void updateToolPanel(InfoPanelScreen tinkerInfo, ToolStack tool, class_1799 result) {
        class_1792 class_17922 = tool.getItem();
        if (class_17922 instanceof ITinkerStationDisplay) {
            ITinkerStationDisplay display = (ITinkerStationDisplay)class_17922;
            tinkerInfo.setCaption(display.getLocalizedName());
            tinkerInfo.setText(display.getStatInformation((IToolStackView)tool, (class_1657)class_310.method_1551().field_1724, new ArrayList<class_2561>(), SafeClientAccess.getTooltipKey(), (class_1836)TinkerTooltipFlags.TINKER_STATION));
        } else {
            tinkerInfo.setCaption(result.method_7964());
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            result.method_7909().method_7851(result, (class_1937)class_310.method_1551().field_1687, list, (class_1836)class_1836.class_1837.field_41070);
            tinkerInfo.setText(list);
        }
    }

    static void updateModifierPanel(InfoPanelScreen modifierInfo, ToolStack tool) {
        class_2561 title;
        ArrayList<class_2561> modifierNames = new ArrayList<class_2561>();
        ArrayList<class_2561> modifierTooltip = new ArrayList<class_2561>();
        if (TinkerStationScreen.method_25441()) {
            title = TRAITS_TEXT;
            Map<Modifier, Integer> upgrades = tool.getUpgrades().getModifiers().stream().collect(Collectors.toMap(ModifierEntry::getModifier, ModifierEntry::getLevel));
            for (ModifierEntry entry : tool.getModifierList()) {
                int level;
                Modifier mod = entry.getModifier();
                if (!mod.shouldDisplay(true) || (level = entry.getLevel() - upgrades.getOrDefault(mod, 0)) <= 0) continue;
                modifierNames.add(mod.getDisplayName(tool, level));
                modifierTooltip.add(mod.getDescription(tool, level));
            }
        } else {
            List<ModifierEntry> modifiers;
            if (TinkerStationScreen.method_25442()) {
                modifiers = tool.getUpgrades().getModifiers();
                title = UPGRADES_TEXT;
            } else {
                modifiers = tool.getModifierList();
                title = MODIFIERS_TEXT;
            }
            for (ModifierEntry entry : modifiers) {
                Modifier mod = entry.getModifier();
                if (!mod.shouldDisplay(true)) continue;
                int level = entry.getLevel();
                modifierNames.add(mod.getDisplayName(tool, level));
                modifierTooltip.add(mod.getDescription(tool, level));
            }
        }
        modifierInfo.setCaption(title);
        modifierInfo.setText(modifierNames, modifierTooltip);
    }

    @Override
    public void updateDisplay() {
        if (this.tile == null) {
            return;
        }
        class_1799 toolStack = ((TinkerStationContainerMenu)((Object)this.getMenu())).getResult();
        ValidatedResult currentError = ((TinkerStationBlockEntity)this.tile).getCurrentError();
        if (currentError.hasError()) {
            this.error(currentError.getMessage());
            return;
        }
        if (toolStack.method_7960() || ((TinkerStationBlockEntity)this.tile).getInputCount() <= 4 && ((TinkerStationContainerMenu)((Object)this.getMenu())).method_7611(0).method_7681()) {
            this.textField.method_1888(false);
            this.textField.method_1852("");
            this.textField.field_22764 = false;
        } else if (!this.textField.method_20316()) {
            this.textField.method_1888(true);
            this.textField.method_1852("");
            this.textField.field_22764 = true;
        } else {
            this.textField.method_1852(((TinkerStationBlockEntity)this.tile).getItemName());
        }
        if (toolStack.method_7960()) {
            toolStack = ((TinkerStationContainerMenu)((Object)this.getMenu())).method_7611(0).method_7677();
        }
        if (toolStack.method_31573(TinkerTags.Items.MODIFIABLE)) {
            ToolStack tool = ToolStack.from(toolStack);
            TinkerStationScreen.updateToolPanel(this.tinkerInfo, tool, toolStack);
            TinkerStationScreen.updateModifierPanel(this.modifierInfo, tool);
        } else {
            this.tinkerInfo.setCaption(this.currentLayout.getDisplayName());
            this.tinkerInfo.setText(this.currentLayout.getDescription());
            class_5250 fullText = class_2561.method_43470((String)"");
            boolean hasComponents = false;
            for (int i = 0; i <= this.activeInputs; ++i) {
                LayoutSlot layout = this.currentLayout.getSlot(i);
                String key = layout.getTranslationKey();
                if (layout.isHidden() || key.isEmpty()) continue;
                hasComponents = true;
                class_5250 textComponent = class_2561.method_43470((String)" * ");
                class_1799 slotStack = ((TinkerStationContainerMenu)((Object)this.getMenu())).method_7611(i).method_7677();
                if (!layout.isValid(slotStack)) {
                    textComponent.method_27692(class_124.field_1061);
                }
                textComponent.method_10852((class_2561)class_2561.method_43471((String)key)).method_27693("\n");
                fullText.method_10852((class_2561)textComponent);
            }
            if (hasComponents) {
                this.modifierInfo.setCaption(COMPONENTS_TEXT);
                this.modifierInfo.setText(new class_2561[]{fullText});
            } else {
                this.modifierInfo.setCaption((class_2561)class_2561.method_43473());
                this.modifierInfo.setText(ASCII_ANVIL);
            }
        }
    }

    @Override
    protected void drawContainerName(class_332 graphics) {
        graphics.method_51439(this.field_22793, this.method_25440(), 8, 8, 0x404040, false);
    }

    public static void renderIcon(class_332 graphics, LayoutIcon icon, int x, int y) {
        Pattern pattern = icon.getValue(Pattern.class);
        if (pattern != null) {
            RenderUtils.setup(class_1723.field_21668);
            RenderSystem.applyModelViewMatrix();
            GuiUtil.renderPattern(graphics, pattern, x, y);
            return;
        }
        class_1799 stack = icon.getValue(class_1799.class);
        if (stack != null) {
            graphics.method_51427(stack, x, y);
        }
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        class_1735 slot;
        int i;
        this.drawBackground(graphics, TINKER_STATION_TEXTURE);
        int x = 0;
        int y = 0;
        float scale = 3.7f;
        float xOff = 12.5f;
        float yOff = 22.0f;
        class_4587 renderPose = graphics.method_51448();
        renderPose.method_22903();
        renderPose.method_46416(12.5f, 22.0f, 0.0f);
        renderPose.method_22905(3.7f, 3.7f, 1.0f);
        TinkerStationScreen.renderIcon(graphics, this.currentLayout.getIcon(), (int)((float)this.cornerX / 3.7f), (int)((float)this.cornerY / 3.7f));
        renderPose.method_22909();
        RenderUtils.setup(TINKER_STATION_TEXTURE, 1.0f, 1.0f, 1.0f, 0.82f);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        ITEM_COVER.draw(graphics, TINKER_STATION_TEXTURE, this.cornerX + 7, this.cornerY + 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.28f);
        if (!this.currentLayout.getToolSlot().isHidden()) {
            class_1735 slot2 = ((TinkerStationContainerMenu)((Object)this.getMenu())).method_7611(0);
            SLOT_BACKGROUND.draw(graphics, TINKER_STATION_TEXTURE, x + this.cornerX + slot2.field_7873 - 1, y + this.cornerY + slot2.field_7872 - 1);
        }
        for (i = 0; i < this.activeInputs; ++i) {
            slot = ((TinkerStationContainerMenu)((Object)this.getMenu())).method_7611(i + 1);
            SLOT_BACKGROUND.draw(graphics, TINKER_STATION_TEXTURE, x + this.cornerX + slot.field_7873 - 1, y + this.cornerY + slot.field_7872 - 1);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i <= this.maxInputs; ++i) {
            slot = ((TinkerStationContainerMenu)((Object)this.getMenu())).method_7611(i);
            if (!(slot instanceof TinkerStationSlot) || ((TinkerStationSlot)slot).isDormant() && !slot.method_7681()) continue;
            SLOT_BORDER.draw(graphics, TINKER_STATION_TEXTURE, x + this.cornerX + slot.field_7873 - 1, y + this.cornerY + slot.field_7872 - 1);
        }
        x = this.buttonsScreen.getLeftPos() - this.leftBeam.w;
        y = this.cornerY;
        x += this.leftBeam.draw(graphics, TINKER_STATION_TEXTURE, x, y);
        x += this.centerBeam.drawScaledX(graphics, TINKER_STATION_TEXTURE, x, y, this.buttonsScreen.getImageWidth());
        this.rightBeam.draw(graphics, TINKER_STATION_TEXTURE, x, y);
        x = this.tinkerInfo.field_2776 - this.leftBeam.w;
        x += this.leftBeam.draw(graphics, TINKER_STATION_TEXTURE, x, y);
        x += this.centerBeam.drawScaledX(graphics, TINKER_STATION_TEXTURE, x, y, this.tinkerInfo.field_2792);
        this.rightBeam.draw(graphics, TINKER_STATION_TEXTURE, x, y);
        for (SlotButtonItem button : this.buttonsScreen.getButtons()) {
            this.buttonDecorationTop.draw(graphics, TINKER_STATION_TEXTURE, button.method_46426(), button.method_46427() - this.buttonDecorationTop.h);
            if (button.buttonId >= this.buttonsScreen.getButtons().size() - 5) continue;
            this.buttonDecorationBot.draw(graphics, TINKER_STATION_TEXTURE, button.method_46426(), button.method_46427() + button.method_25364());
        }
        this.panelDecorationL.draw(graphics, TINKER_STATION_TEXTURE, this.tinkerInfo.field_2776 + 5, this.tinkerInfo.field_2800 - this.panelDecorationL.h);
        this.panelDecorationR.draw(graphics, TINKER_STATION_TEXTURE, this.tinkerInfo.guiRight() - 5 - this.panelDecorationR.w, this.tinkerInfo.field_2800 - this.panelDecorationR.h);
        this.panelDecorationL.draw(graphics, TINKER_STATION_TEXTURE, this.modifierInfo.field_2776 + 5, this.modifierInfo.field_2800 - this.panelDecorationL.h);
        this.panelDecorationR.draw(graphics, TINKER_STATION_TEXTURE, this.modifierInfo.guiRight() - 5 - this.panelDecorationR.w, this.modifierInfo.field_2800 - this.panelDecorationR.h);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        for (int i2 = 0; i2 <= this.maxInputs; ++i2) {
            Pattern icon;
            slot = ((TinkerStationContainerMenu)((Object)this.getMenu())).method_7611(i2);
            if (slot.method_7681() || (icon = this.currentLayout.getSlot(i2).getIcon()) == null) continue;
            GuiUtil.renderPattern(graphics, icon, this.cornerX + slot.field_7873, this.cornerY + slot.field_7872);
        }
        RenderSystem.enableDepthTest();
        super.method_2389(graphics, partialTicks, mouseX, mouseY);
        this.buttonsScreen.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.textField != null && this.textField.field_22764) {
            RenderUtils.setup(TINKER_STATION_TEXTURE, 1.0f, 1.0f, 1.0f, 1.0f);
            TEXT_BOX.draw(graphics, TINKER_STATION_TEXTURE, this.cornerX + 79, this.cornerY + 3);
            this.textField.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.tinkerInfo.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        if (this.modifierInfo.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        if (this.buttonsScreen.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unkowwn) {
        if (this.tinkerInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        if (this.modifierInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        return super.method_25403(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unkowwn);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.tinkerInfo.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        if (this.modifierInfo.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int state) {
        if (this.tinkerInfo.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        if (this.modifierInfo.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        if (this.buttonsScreen.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.method_25406(mouseX, mouseY, state);
    }

    static boolean needsDisplayUpdate(int keyCode) {
        if (keyCode == 340 || keyCode == 344) {
            return true;
        }
        if (class_310.field_1703) {
            return keyCode == 343 || keyCode == 347;
        }
        return keyCode == 341 || keyCode == 345;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        if (this.textField.method_20315()) {
            this.textField.method_25404(keyCode, scanCode, modifiers);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    public void method_2385(class_332 graphics, class_1735 slotIn) {
        if (slotIn instanceof TinkerStationSlot && ((TinkerStationSlot)slotIn).isDormant() && !slotIn.method_7681()) {
            return;
        }
        super.method_2385(graphics, slotIn);
    }

    @Override
    public boolean method_2387(class_1735 slotIn, double mouseX, double mouseY) {
        if (slotIn instanceof TinkerStationSlot && ((TinkerStationSlot)slotIn).isDormant() && !slotIn.method_7681()) {
            return false;
        }
        return super.method_2387(slotIn, mouseX, mouseY);
    }

    protected void wood() {
        this.tinkerInfo.wood();
        this.modifierInfo.wood();
        this.buttonDecorationTop = SLOT_SPACE_TOP.shift(TinkerStationScreen.SLOT_SPACE_TOP.w, 0);
        this.buttonDecorationBot = SLOT_SPACE_BOTTOM.shift(TinkerStationScreen.SLOT_SPACE_BOTTOM.w, 0);
        this.panelDecorationL = PANEL_SPACE_LEFT.shift(18, 0);
        this.panelDecorationR = PANEL_SPACE_RIGHT.shift(18, 0);
        this.leftBeam = LEFT_BEAM;
        this.rightBeam = RIGHT_BEAM;
        this.centerBeam = CENTER_BEAM;
    }

    protected void metal() {
        this.tinkerInfo.metal();
        this.modifierInfo.metal();
        this.buttonDecorationTop = SLOT_SPACE_TOP.shift(TinkerStationScreen.SLOT_SPACE_TOP.w * 2, 0);
        this.buttonDecorationBot = SLOT_SPACE_BOTTOM.shift(TinkerStationScreen.SLOT_SPACE_BOTTOM.w * 2, 0);
        this.panelDecorationL = PANEL_SPACE_LEFT.shift(36, 0);
        this.panelDecorationR = PANEL_SPACE_RIGHT.shift(36, 0);
        this.leftBeam = LEFT_BEAM.shift(0, TinkerStationScreen.LEFT_BEAM.h);
        this.rightBeam = RIGHT_BEAM.shift(0, TinkerStationScreen.RIGHT_BEAM.h);
        this.centerBeam = CENTER_BEAM.shift(0, TinkerStationScreen.CENTER_BEAM.h);
    }

    @Override
    public void error(class_2561 message) {
        this.tinkerInfo.setCaption(COMPONENT_ERROR);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption((class_2561)class_2561.method_43473());
        this.modifierInfo.setText(new class_2561[]{class_2561.method_43473()});
    }

    @Override
    public void warning(class_2561 message) {
        this.tinkerInfo.setCaption(COMPONENT_WARNING);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption((class_2561)class_2561.method_43473());
        this.modifierInfo.setText(new class_2561[]{class_2561.method_43473()});
    }

    public void onToolSelection(StationSlotLayout layout) {
        this.activeInputs = Math.min(layout.getInputCount(), this.maxInputs);
        this.currentLayout = layout;
        this.updateLayout();
        TinkerNetwork.getInstance().sendToServer(new TinkerStationSelectionPacket(layout.getName()));
    }

    @Override
    public List<class_768> getModuleAreas() {
        List<class_768> list = super.getModuleAreas();
        list.add(this.buttonsScreen.getArea());
        return list;
    }

    @Override
    protected boolean method_2381(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.method_2381(mouseX, mouseY, guiLeft, guiTop, mouseButton) && !this.buttonsScreen.method_25405(mouseX, mouseY);
    }

    private void onNameChanged(String name) {
        if (this.tile != null) {
            ((TinkerStationBlockEntity)this.tile).setItemName(name);
            TinkerNetwork.getInstance().sendToServer(new TinkerStationRenamePacket(name));
        }
    }

    public void method_37432() {
        super.method_37432();
        this.textField.method_1865();
    }

    @Override
    public void method_25410(class_310 pMinecraft, int pWidth, int pHeight) {
        String s = this.textField.method_1882();
        super.method_25410(pMinecraft, pWidth, pHeight);
        this.textField.method_1852(s);
    }

    public void method_25432() {
        super.method_25432();
        assert (this.field_22787 != null);
    }

    public void method_25419() {
        super.method_25419();
        assert (this.field_22787 != null);
    }

    @Nonnull
    public StationSlotLayout getDefaultLayout() {
        return this.defaultLayout;
    }

    @Nonnull
    public StationSlotLayout getCurrentLayout() {
        return this.currentLayout;
    }

    public int getMaxInputs() {
        return this.maxInputs;
    }
}

